/*
 * Remembers which button in the planning table was clicked.
 */
var clickedButton;

/**
 * Initialize the widget. Called once.
 * 
 * This function implements the PageLoad event handler,
 * initialized the widget and
 * registers the button click event handler. 
 * 
 * @returns void
 */
function initializeWidget()
{
	/*
	 * Subscribe to the EmbeddedApp onPageLoad event before initializing the widget
	 */
	ZOHO.embeddedApp.on("PageLoad",function(data)
	{
		
	 	// Verify if EntityInformation is passed.
		if(data && data.Entity)
		{
			$('#entity').val(data.Entity);
			$('#entityid').val(data.EntityId[0]);
		}

	});
	
	/*
	 * initialize the widget.
	 */
	ZOHO.embeddedApp.init();
	
	/*
	 * Button click handlers.
	 * Create a closed pre-intake call.
	 */
	$(document).on('click', '#voicemail', function() {
		createCall('Voicemail');
	});
	$(document).on('click', '#unreachable', function() {
		createCall('Geen gehoor');
	});
	$(document).on('click', '#uninterested', function() {
		createCall('Niet geinteresseerd');
	});
	$(document).on('click', '#callback', function() {
		createCall('Wil teruggebeld worden');
	});
	
	function createCall(result)
	{
		$('.error').hide();
		var entity = $('#entity').val();
		var entityId = $('#entityid').val();
		var date = new Date;
		date = date.toISOString().substr(0,19) + '+00:00';
		
		var data = [{
			'Call_Start_Time': date,
			'Call_Purpose': 'Pre-intake',
			'What_Id': entityId,
			'Subject': 'Pre-intake',
			'Call_Type': 'Outbound',
			'Call_Result': result,
			'$se_module': entity
		}];

		// Create the call.
		ZOHO.CRM.API.insertRecord({Entity:"Calls",APIData:data,Trigger:["workflow"]}).then(function(data){
			ZOHO.CRM.UI.Popup.close();
		},function(error){
			$('.error').show();
		});
	}
}
